; vim: set ts=4 sw=4 sts=4 expandtab: =========================================;
;                  [ 御殿谷サキ from ヴァンガードプリンセス ]                  ;
;==============================================================================;

;==============================================================================;
; サポート しえら
;==============================================================================;
;------------------------------------------------------------------------------;
; しえら 立ち
;------------------------------------------------------------------------------;
[Statedef 20000]
type        = S
movetype    = I
physics     = S
anim        = 20000
ctrl        = 0
velset      = 0, 0
sprpriority = -1

;-------[ Effects ]-------;

;[State 20000:           Pal]
;type     = PalFX
;trigger1 = 1
;add      = -32, -32, -32
;time     = 1

;-------[ Movement ]-------;

[State 20000:           Turn]
type     = Turn
trigger1 = P2Dist X < (-10 * Root,fvar(31))

[State 20000:           Pos, 1]
type     = PosSet
trigger1 = Time = 0
y        = 0

;-------[ States ]-------;

[State 20000:           Walk to Root]
type       = ChangeState
triggerall = Root,Alive
triggerall = Abs(RootDist X) > Ceil(180 * const(size.xscale))
trigger1   = FrontEdgeBodyDist > Floor(60 * const(size.xscale))
trigger2   = RootDist X < 0
value      = 20010

[State 20000:           Walk to Window]
type     = ChangeState
trigger1 = BackEdgeBodyDist < (0 - Floor(60 * const(size.xscale)))
trigger2 = FrontEdgeBodyDist < (0 - Floor(60 * const(size.xscale)))
value    = 20010

[State 20000:           Match Over (Win)]
type       = ChangeState
triggerall = RoundState > 3
triggerall = Root,Alive
trigger1   = Win
trigger1   = Root,StateNo = [180, 189]
value      = 20100

[State 20000:           Match Over (Lose)]
type       = ChangeState
triggerall = RoundState > 3
trigger1   = Lose
trigger1   = Root,StateNo = [170, 179]
trigger2   = !Root,Alive
trigger3   = DrawGame
value      = 20110

;------------------------------------------------------------------------------;
; しえら 移動
;------------------------------------------------------------------------------;
[Statedef 20010]
type        = S
movetype    = I
physics     = N
anim        = 20010
ctrl        = 0
sprpriority = -1

;-------[ Effects ]-------;

;[State 20010:           Pal]
;type     = PalFX
;trigger1 = 1
;add      = -32, -32, -32
;time     = 1

;-------[ Movement ]-------;

[State 20010:           Turn]
type     = Turn
trigger1 = Time = 0
trigger1 = Root,Alive
trigger1 = RootDist X < 0
trigger2 = Vel X > 0
trigger2 = Root,Alive
trigger2 = RootDist X < Floor(-40 * const(size.xscale))
trigger3 = FrontEdgeBodyDist < Floor(-20 * const(size.xscale))

[State 20010:           Vel, 1]
type       = VelSet
trigger1   = Root,Alive
trigger1   = Abs(RootDist X) >= Ceil(80 * const(size.xscale))
trigger2   = !Root,Alive
trigger2   = FrontEdgeBodyDist > Floor(60 * const(size.xscale))
trigger2   = BackEdgeBodyDist < Floor(60 * const(size.xscale))
x          = Root,const(velocity.walk.fwd.x) * ifelse(Abs(RootDist X) > (960 * const(size.xscale)), 2.5, 1.25)
persistent = 1

[State 20010:           Vel, 2]
type       = VelSet
triggerall = Root,Alive
trigger1   = Abs(RootDist X) < Ceil(80 * const(size.xscale))
trigger1   = Abs(Root,Vel X) = [Root,const(velocity.walk.fwd.x) / 3, Root,const(velocity.walk.fwd.x) * 1.25]
x          = Abs(Root,Vel X)
persistent = 1

;-------[ States ]-------;

[State 20010:           Standing]
type       = ChangeState
triggerall = BackEdgeBodyDist >= Floor(60 * const(size.xscale)) || FrontEdgeBodyDist <= Floor(60 * const(size.xscale))
trigger1   = Root,Alive
trigger1   = Abs(Root,Vel X) <= (Root,const(velocity.walk.fwd.x) / 3)
trigger1   = Abs(RootDist X) < Ceil(80 * const(size.xscale))
trigger2   = Root,Alive = 0
value      = 20000

;------------------------------------------------------------------------------;
; しえら 勝利
;------------------------------------------------------------------------------;
[Statedef 20100]
type        = S
movetype    = I
physics     = S
anim        = 20100
ctrl        = 0
sprpriority = -1
velset      = 0, 0

;-------[ Null ]-------;

[State 20100:           Null]
type     = Null
trigger1 = Time = 0

;------------------------------------------------------------------------------;
; しえら 敗北
;------------------------------------------------------------------------------;
[Statedef 20110]
type        = S
movetype    = I
physics     = S
anim        = 20110
ctrl        = 0
sprpriority = -1
velset      = 0, 0

;-------[ Null ]-------;

[State 20100:           Null]
type     = Null
trigger1 = Time = 0

;==============================================================================;
; しえら攻撃
;==============================================================================;
;------------------------------------------------------------------------------;
; しえら 攻撃1
;------------------------------------------------------------------------------;
[Statedef 20200]
type        = S
movetype    = A
physics     = S
anim        = 20200
ctrl        = 0
facep2      = 1
sprpriority = 1

;-------[ Support Gauge ]-------;

[State 20200:           Support Gauge]
type     = ParentVarAdd
trigger1 = Time = 0
v        = 25
value    = -150

[State 20200:           Support Counter]
type       = ParentVarSet
triggerall = Root,MoveType = H
triggerall = Root,var(26) <= 0
trigger1   = Root,StateNo != 0              ; 以降ガード解除後にサポカンが発生するバグ対策
trigger1   = Root,StateNo != [10, 12]
trigger1   = Root,StateNo != 20
trigger1   = Root,StateNo != [40, 52]
trigger1   = Root,StateNo != [100, 119]
trigger1   = Root,StateNo != [120, 155]
trigger1   = Root,StateNo != [900, 930]
v          = 26
value      = 3 * TicksPerSecond

;-------[ Sounds ]-------;

[State 20200:           SE, 1]
type     = PlaySnd
trigger1 = AnimElem = 4
value    = 6, 1

;-------[ Projectiles ]-------;

[State 20200:           Projectile, 1]
type             = Projectile
trigger1         = AnimElemTime(4) = 0
projid           = 20200
projanim         = 20205
projhitanim      = -1
projremanim      = -1
projremove       = 1
projremovetime   = 6
projhits         = 1
projpriority     = 1
projsprpriority  = 10
offset           = 0, 0
velocity         = Vel X, Vel Y
animtype         = Medium
attr             = S, NA
damage           = 25, 0
hitflag          = MAF
guardflag        = M
pausetime        = 0, 8
sparkno          = S6000 + Random % 8
guard.sparkno    = S6061
sparkxy          = Floor(170 * const(size.xscale)), Floor(-90 * const(size.yscale))
hitsound         = S7, 1
guardsound       = S8, 1
ground.type      = High
ground.hittime   = 17
ground.slidetime = 16
ground.velocity  = -6 * Root,fvar(31)
guard.ctrltime   = 15
air.hittime      = 16
air.velocity     = -3 * Root,fvar(31), -3 * Root,fvar(31)
air.juggle       = 1
air.fall         = 1
fall.recover     = 1
fall.recovertime = 30
id               = 20200

;-------[ States ]-------;

[State 20200:           Standing]
type     = ChangeState
trigger1 = AnimTime = 0
value    = 20000

;------------------------------------------------------------------------------;
; しえら 攻撃2
;------------------------------------------------------------------------------;
[Statedef 20210]
type        = S
movetype    = A
physics     = S
anim        = 20210
ctrl        = 0
facep2      = 1
sprpriority = 1

;-------[ Support Gauge ]-------;

[State 20200:           Support Gauge]
type     = ParentVarAdd
trigger1 = Time = 0
v        = 25
value    = -220

[State 20200:           Support Counter]
type       = ParentVarSet
triggerall = Root,MoveType = H
triggerall = Root,var(26) <= 0
trigger1   = Root,StateNo != 0              ; 以降ガード解除後にサポカンが発生するバグ対策
trigger1   = Root,StateNo != [10, 12]
trigger1   = Root,StateNo != 20
trigger1   = Root,StateNo != [40, 52]
trigger1   = Root,StateNo != [100, 119]
trigger1   = Root,StateNo != [120, 155]
trigger1   = Root,StateNo != [900, 930]
v          = 26
value      = 5 * TicksPerSecond

;-------[ Sounds ]-------;

[State 20210:           SE, 1]
type     = PlaySnd
trigger1 = AnimElem = 2
value    = 3, 60

[State 20210:           Fire, 1]
type     = PlaySnd
trigger1 = AnimElem = 7
trigger2 = AnimElem = 9
trigger3 = AnimElem = 11
trigger4 = AnimElem = 13
trigger5 = AnimElem = 15
value    = 3, 10

;-------[ Effects ]-------;

[State 20210:           Shield On]
type        = Helper
trigger1    = AnimElem = 2
helpertype  = Normal
name        = "Route"
stateno     = 7510
id          = 7510
postype     = p1
pos         = 0, 0
ownpal      = 1
size.xscale = const(size.xscale)
size.yscale = const(size.yscale)

[State 20210:           Fire Dust]
type        = Explod
trigger1    = AnimElem = 7
trigger2    = AnimElem = 9
trigger3    = AnimElem = 11
trigger4    = AnimElem = 13
trigger5    = AnimElem = 15
anim        = 7520
id          = 7520
postype     = p1
pos         = 0, 0
bindtime    = -1
removetime  = 2
ownpal      = 1
sprpriority = 3
scale       = const(size.xscale), const(size.yscale)

[State 20210:           Fire Dust]
type        = Explod
trigger1    = AnimElem = 7
trigger2    = AnimElem = 9
trigger3    = AnimElem = 11
trigger4    = AnimElem = 13
trigger5    = AnimElem = 15
anim        = 7521
id          = 7521
postype     = p1
pos         = Floor(38 * const(size.xscale)), Floor(-155 * const(size.yscale))
removetime  = 30
ownpal      = 1
sprpriority = 3
velocity    = -5 * Root,fvar(31), -4 * Root,fvar(31)
accel       = 0, 0.4
scale       = const(size.xscale), const(size.yscale)

;-------[ Projectiles ]-------;

[State 20210:           Projectile, 1]
type             = Projectile
trigger1         = AnimElem = 7
trigger2         = AnimElem = 9
trigger3         = AnimElem = 11
trigger4         = AnimElem = 13
trigger5         = AnimElem = 15
projid           = 20210
projanim         = 20215
projhitanim      = -1
projremanim      = -1
projremove       = 1
projremovetime   = -1
projhits         = 1
projpriority     = 1
projsprpriority  = 10
offset           = Floor(114 * const(size.xscale)), Floor(-150 * const(size.yscale))
velocity         = 30 * Root,fvar(31), 0
animtype         = Medium
attr             = S, NP
damage           = 7, 0
hitflag          = MAF
guardflag        = MA
pausetime        = 0, 8
sparkno          = S6000 + Random % 8
guard.sparkno    = S6061
sparkxy          = 0, 0
hitsound         = S7, 3
guardsound       = S8, 0
ground.type      = Low
ground.hittime   = 14
ground.slidetime = 13
ground.velocity  = -6 * Root,fvar(31)
guard.ctrltime   = 12
air.hittime      = 13
air.velocity     = -3 * Root,fvar(31), -1 * Root,fvar(31)
air.juggle       = 0
air.fall         = 1
fall.recover     = 1
fall.recovertime = 30
id               = 20210

;-------[ States ]-------;

[State 20200:           Standing]
type     = ChangeState
trigger1 = AnimTime = 0
value    = 20000

;------------------------------------------------------------------------------;
; しえら 攻撃3
;------------------------------------------------------------------------------;
[Statedef 20220]
type        = S
movetype    = A
physics     = S
anim        = 20220
ctrl        = 0
facep2      = 1
sprpriority = 1

;-------[ Support Gauge ]-------;

[State 20200:           Support Gauge]
type     = ParentVarAdd
trigger1 = Time = 0
v        = 25
value    = -250

[State 20200:           Support Counter]
type       = ParentVarSet
triggerall = Root,MoveType = H
triggerall = Root,var(26) <= 0
trigger1   = Root,StateNo != 0              ; 以降ガード解除後にサポカンが発生するバグ対策
trigger1   = Root,StateNo != [10, 12]
trigger1   = Root,StateNo != 20
trigger1   = Root,StateNo != [40, 52]
trigger1   = Root,StateNo != [100, 119]
trigger1   = Root,StateNo != [120, 155]
trigger1   = Root,StateNo != [900, 930]
v          = 26
value      = 6 * TicksPerSecond

;-------[ Movement ]-------;

[State 20220:           State Type]
type      = StateTypeSet
trigger1  = AnimElem = 3
statetype = A
movetype  = A
physics   = N

[State 20220:           Vel, 1]
type     = VelSet
trigger1 = AnimElem = 3
x        = 1 * Root,fvar(31)

;-------[ Sounds ]-------;

[State 20220:           SE, 1]
type     = PlaySnd
trigger1 = AnimElem = 3
value    = 3, 63

;-------[ Effects ]-------;

[State 20220:           Shield On]
type        = Helper
trigger1    = AnimElem = 3
helpertype  = Normal
name        = "Shield On"
stateno     = 7500
id          = 7500
postype     = p1
pos         = 0, 0
ownpal      = 1
size.xscale = const(size.xscale)
size.yscale = const(size.yscale)

;-------[ Projectile Control ]-------;

[State 20220:           Reset Hit Flag]
type     = VarSet
trigger1 = Time = 0
trigger2 = var(0) > 16
v        = 0
value    = 0

[State 20220:           Reset Hit Count]
type     = VarSet
trigger1 = Time = 0
v        = 1
value    = 0

[State 20220:           Hit Time]
type     = VarAdd
trigger1 = var(0)
v        = 0
value    = 1

[State 20220:           Hit Flag]
type       = VarSet
triggerall = !var(0)
trigger1   = Root,NumProjID(20220)
trigger1   = Root,ProjContactTime(20220) = 1
v          = 0
value      = 1

[State 20220:           Hit Count]
type     = VarAdd
trigger1 = var(0) = 1
v        = 1
value    = 1

;-------[ Projectiles ]-------;

[State 20210:           Projectile, 1]
type             = Projectile
triggerall       = !Root,NumProjID(20220)
triggerall       = !var(0)
triggerall       = var(1) < 4
trigger1         = AnimElemTime(4) >= 0
projid           = 20220
projanim         = 20225
projhitanim      = -1
projremanim      = -1
projremove       = 0
projremovetime   = 2
projhits         = 1
projpriority     = 1
projsprpriority  = 10
offset           = 0, 0
velocity         = Vel X, Vel Y
animtype         = Medium
attr             = S, NA
damage           = 22, 0
hitflag          = MAF
guardflag        = MA
pausetime        = 8, 8
sparkno          = S6000 + Random % 8
guard.sparkno    = S6061
sparkxy          = Floor(50 * const(size.xscale)), Floor(-120 * const(size.yscale))
hitsound         = S7, 2
guardsound       = S8, 1
ground.type      = High
ground.hittime   = 18
ground.slidetime = 17
ground.velocity  = -3 * Root,fvar(31), -2 * Root,fvar(31)
guard.ctrltime   = 16
guard.velocity   = -7 * Root,fvar(31)
air.hittime      = 17
air.velocity     = -2 * Root,fvar(31), -3 * Root,fvar(31)
air.juggle       = 0
air.fall         = 1
fall.recover     = 0
id               = 20220

;-------[ States ]-------;

[State 20220:           Landing]
type     = ChangeState
trigger1 = Time > (13 + (24 * 5))
trigger2 = Time % 24 = 13
trigger2 = var(1) >= 4
value    = 20221

;------------------------------------------------------------------------------;
; しえら 攻撃3 着地
;------------------------------------------------------------------------------;
[Statedef 20221]
type        = A
movetype    = I
physics     = N
anim        = 20221
ctrl        = 0
sprpriority = 1

;-------[ Movement ]-------;

[State 20221:           Vel, 1]
type     = VelSet
trigger1 = AnimElem = 2
x        = 0

[State 20221:           Vel, 2]
type     = VelSet
trigger1 = AnimElem = 3
y        = 0

[State 20221:           Pos, 1]
type     = PosSet
trigger1 = AnimElem = 3
y        = 0

;-------[ States ]-------;

[State 20221:           Standing]
type     = ChangeState
trigger1 = AnimTime = 0
value    = 20000

;------------------------------------------------------------------------------;
; しえら 攻撃4
;------------------------------------------------------------------------------;
[Statedef 20230]
type        = A
movetype    = A
physics     = N
anim        = 20230
ctrl        = 0
sprpriority = 1

;-------[ Support Gauge ]-------;

[State 20200:           Support Gauge]
type     = ParentVarAdd
trigger1 = Time = 0
v        = 25
value    = -310

[State 20200:           Support Counter]
type       = ParentVarSet
triggerall = Root,MoveType = H
triggerall = Root,var(26) <= 0
trigger1   = Root,StateNo != 0              ; 以降ガード解除後にサポカンが発生するバグ対策
trigger1   = Root,StateNo != [10, 12]
trigger1   = Root,StateNo != 20
trigger1   = Root,StateNo != [40, 52]
trigger1   = Root,StateNo != [100, 119]
trigger1   = Root,StateNo != [120, 155]
trigger1   = Root,StateNo != [900, 930]
v          = 26
value      = 6 * TicksPerSecond

;-------[ Movement ]-------;

[State 20230:           Vel, 1]
type     = VelSet
trigger1 = AnimElem = 1
x        = 0
y        = -7 * Root,fvar(31)

[State 20230:           Vel, 2]
type     = VelSet
trigger1 = AnimElem = 3
y        = 0

[State 20230:           Vel, 4, Gravity, 1]
type     = VelMul
trigger1 = AnimElemTime(2) < 0
y        = 0.9

[State 20230:           Vel, 3, Gravity]
type     = VelAdd
trigger1 = Time > (22 + (12 * 4))
y        = 0.35 * Root,fvar(31)

;-------[ Sounds ]-------;

[State 20230:           SE, 1]
type     = PlaySnd
trigger1 = AnimElem = 1
value    = 3, 61

;-------[ Effects ]-------;

[State 20230:           Dust, 1]
type        = Explod
trigger1    = AnimElemTime(6) = 2
anim        = 7530
postype     = p1
pos         = Floor(20 * const(size.xscale)), Floor(-200 * const(size.yscale))
ownpal      = 1
scale       = const(size.xscale), const(size.yscale)
facing      = 1
sprpriority = 3

[State 20230:           Dust, 2]
type        = Explod
trigger1    = AnimElemTime(7) = 2
anim        = 7531
postype     = p1
pos         = Floor(37 * const(size.xscale)), Floor(-200 * const(size.yscale))
ownpal      = 1
scale       = const(size.xscale), const(size.yscale)
facing      = 1
sprpriority = 3

[State 20230:           Dust, 3]
type        = Explod
trigger1    = AnimElemTime(8) = 2
anim        = 7530
postype     = p1
pos         = Floor(-42 * const(size.xscale)), Floor(-200 * const(size.yscale))
ownpal      = 1
scale       = const(size.xscale), const(size.yscale)
facing      = -1
sprpriority = 3

[State 20230:           Dust, 4]
type        = Explod
trigger1    = AnimElemTime(9) = 2
anim        = 7531
postype     = p1
pos         = Floor(-60 * const(size.xscale)), Floor(-200 * const(size.yscale))
ownpal      = 1
scale       = const(size.xscale), const(size.yscale)
facing      = -1
sprpriority = 3

[State 20230:           Empty Missile]
type        = Explod
trigger1    = AnimElem = 6
anim        = 20231
id          = 20231
postype     = p1
pos         = 0, 0
scale       = const(size.xscale), const(size.yscale)
bindtime    = -1
ownpal      = 0
sprpriority = 2

;-------[ Fire ]-------;

[State 20230:           Missile, 1]
type        = Helper
trigger1    = AnimElem = 6
helpertype  = Normal
name        = "Missile"
stateno     = 7540
id          = 7540
postype     = p1
pos         = Floor(20 * const(size.xscale)), Floor(-199 * const(size.yscale))
ownpal      = 1
size.xscale = const(size.xscale)
size.yscale = const(size.yscale)

[State 20230:           Missile, 2]
type        = Helper
trigger1    = AnimElem = 7
helpertype  = Normal
name        = "Missile"
stateno     = 7540
id          = 7541
postype     = p1
pos         = Floor(37 * const(size.xscale)), Floor(-199 * const(size.yscale))
ownpal      = 1
size.xscale = const(size.xscale)
size.yscale = const(size.yscale)

[State 20230:           Missile, 3]
type        = Helper
trigger1    = AnimElem = 8
helpertype  = Normal
name        = "Missile"
stateno     = 7540
id          = 7542
postype     = p1
pos         = Floor(-41 * const(size.xscale)), Floor(-200 * const(size.yscale))
ownpal      = 1
size.xscale = const(size.xscale)
size.yscale = const(size.yscale)

[State 20230:           Missile, 4]
type        = Helper
trigger1    = AnimElem = 9
helpertype  = Normal
name        = "Missile"
stateno     = 7540
id          = 7543
postype     = p1
pos         = Floor(-58 * const(size.xscale)), Floor(-200 * const(size.yscale))
ownpal      = 1
size.xscale = const(size.xscale)
size.yscale = const(size.yscale)

;-------[ States ]-------;

[State 20230:           Landing]
type     = ChangeState
trigger1 = Vel Y > 0
trigger1 = Pos Y >= 0
value    = 20231

;------------------------------------------------------------------------------;
; しえら 攻撃4 着地
;------------------------------------------------------------------------------;
[Statedef 20231]
type        = S
movetype    = I
physics     = S
ctrl        = 0
sprpriority = 1

;-------[ Movement ]--------;

[State 20231:           Vel, 1]
type     = VelSet
trigger1 = Time = 0
y        = 0

[State 20231:           Pos, 1]
type     = PosSet
trigger1 = Time = 0
y        = 0

;-------[ Effects ]-------;

[State 20231:           Remove]
type     = RemoveExplod
trigger1 = Time = 0
id       = 20231

;-------[ States ]-------;

[State 20231:           Standing]
type     = ChangeState
trigger1 = Time = 0
value    = 20000


;==============================================================================;
; しえら プロクシガード
;==============================================================================;
;------------------------------------------------------------------------------;
; プロクシガード 発生
;------------------------------------------------------------------------------;
[Statedef 20300]
type        = S
movetype    = A
physics     = S
anim        = 20300
ctrl        = 0
vel         = 0, 0
facep2      = 1
sprpriority = 1

;-------[ Support Gauge ]-------;

[State 20200:           Support Gauge]
type     = ParentVarAdd
trigger1 = Time = 0
v        = 25
value    = -30

[State 20200:           Support Counter]
type       = ParentVarSet
triggerall = PrevStateNo != 20301
triggerall = Root,MoveType = H
triggerall = Root,var(26) <= 0
trigger1   = Root,StateNo != 0              ; 以降ガード解除後にサポカンが発生するバグ対策
trigger1   = Root,StateNo != [10, 12]
trigger1   = Root,StateNo != 20
trigger1   = Root,StateNo != [40, 52]
trigger1   = Root,StateNo != [100, 119]
trigger1   = Root,StateNo != [120, 155]
v          = 26
value      = 3 * TicksPerSecond

;-------[ Movement ]-------;

[State 20300:           Attack Dist to 0]
type     = AttackDist
trigger1 = AnimElemTime(2) < 0
value    = 0

[State 20300:           State Type]
type      = StateTypeSet
trigger1  = AnimElem = 2
statetype = S
movetype  = I
physics   = S

[State 20300:           Hit, 1]
type     = HitBy
trigger1 = AnimElemTime(2) < 0
value    = SCA, NP, SP, HP
time     = 1

[State 20300:           Hit, 2]
type     = NotHitBy
trigger1 = AnimElemTime(2) >= 0
value    = SCA, NA, SA, HA, NT, ST, HT, NP, SP, HP
time     = 1

;-------[ Effects ]-------;

[State 20300:           Effects]
type        = Explod
trigger1    = Time = 0
anim        = 7600
postype     = p1
pos         = Floor(35 * const(size.xscale)), Floor(-182 * const(size.yscale))
ownpal      = 1
bindtime    = -1
scale       = const(size.xscale), const(size.yscale)
sprpriority = 2

;-------[ Sounds ]--------;

[State 20300:           SE, 1]
type     = PlaySnd
trigger1 = Time = 0
value    = 3, 74

;-------[ Hit Defs ]-------;

[State 20300:           Reversal]
type          = ReversalDef
trigger1      = Time = 0
attr          = S, NA
reversal.attr = SCA, NP, SP, HP
sparkno       = -1
sparkxy       = 0, 0
hitsound      = -1  ;S3, 122
p1stateno     = 20301

[State 20300:           Hit Override]
type     = HitOverride
trigger1 = AnimElemTime(2) < 0
attr     = SCA, NP, SP, HP
slot     = 1
stateno  = 20301
time     = 1

;-------[ States ]-------;

[State 20300:           Standing]
type     = ChangeState
trigger1 = AnimTime = 0
value    = 20000

;------------------------------------------------------------------------------;
; プロクシガード 成立
;------------------------------------------------------------------------------;
[Statedef 20301]
type        = S
movetype    = I
physics     = S
anim        = 20301
ctrl        = 0
vel         = 0, 0
sprpriority = 1

;-------[ Effects ]-------;

[State 20301:           Pal, 1]
type     = PalFX
trigger1 = Time = 0
add      = 255, 255, 255
time     = 4

;-------[ Sounds ]-------;

[State 20301:           SE, 1]
type     = PlaySnd
trigger1 = Time = 0
value    = 3, 122
channel  = 3

;-------[ Movement ]-------;

[State 20301:           Pause]
type     = Pause
trigger1 = Time = 0
time     = 15
movetime = 15

;-------[ States ]-------;

[State 20301:           Proxy]
type     = ChangeState
trigger1 = Time = 15
trigger1 = Root,var(25) > 0
value    = 20300

[State 20301:           No Gauge]
type     = ChangeAnim
trigger1 = Time = 15
value    = 20300
elem     = 2

[State 20301:           Return Standing]
type     = ChangeState
trigger1 = Anim = 20300
trigger1 = AnimTime = 0
value    = 20000


;==============================================================================;
; サポート ヒルダ
;==============================================================================;
;------------------------------------------------------------------------------;
; ヒルダ 立ち
;------------------------------------------------------------------------------;
[Statedef 21000]
type        = S
movetype    = I
physics     = N
anim        = 21000
ctrl        = 0
velset      = 0, 0
sprpriority = -1

;-------[ Helpers ]-------;

[State 21000:           Maya & Kaya]
type        = Helper
trigger1    = !NumHelper(21500)
helpertype  = Normal
name        = "Maya&Kaya"
stateno     = 21550
id          = 21500
ownpal      = 1
size.xscale = const(size.xscale)
size.yscale = const(size.yscale)

;-------[ Effects ]-------;

;[State 20000:           Pal]
;type     = PalFX
;trigger1 = 1
;add      = -32, -32, -32
;time     = 1

;-------[ Movement ]-------;

[State 20000:           Turn]
type     = Turn
trigger1 = P2Dist X < (-10 * Root,fvar(31))

[State 21000:           Flow]
type     = VelSet
trigger1 = 1
y        = 0 - sin(Time * PI / 45) * const(size.yscale) * (0.5 * Root,fvar(31))

[State 20000:           Pos, 1]
type     = PosSet
trigger1 = Time = 0
y        = 0

;-------[ States ]-------;

[State 20000:           Walk to Root]
type       = ChangeState
triggerall = Root,Alive
triggerall = Abs(RootDist X) > Ceil(180 * const(size.xscale))
trigger1   = FrontEdgeBodyDist > Floor(60 * const(size.xscale))
trigger2   = RootDist X < 0
value      = 21010

[State 20000:           Walk to Window]
type     = ChangeState
trigger1 = BackEdgeBodyDist < (0 - Floor(60 * const(size.xscale)))
trigger2 = FrontEdgeBodyDist < (0 - Floor(60 * const(size.xscale)))
value    = 21010

[State 20000:           Match Over (Win)]
type       = ChangeState
triggerall = RoundState > 3
triggerall = Root,Alive
trigger1   = Win
trigger1   = Root,StateNo = [180, 189]
value      = 21100

[State 20000:           Match Over (Lose)]
type       = ChangeState
triggerall = RoundState > 3
trigger1   = Lose
trigger1   = Root,StateNo = [170, 179]
trigger2   = !Root,Alive
trigger3   = DrawGame
value      = 21110

;------------------------------------------------------------------------------;
; ヒルダ 移動
;------------------------------------------------------------------------------;
[Statedef 21010]
type        = S
movetype    = I
physics     = N
anim        = 21010
ctrl        = 0
sprpriority = -1

;-------[ Effects ]-------;

;[State 20010:           Pal]
;type     = PalFX
;trigger1 = 1
;add      = -32, -32, -32
;time     = 1

;-------[ Movement ]-------;

[State 21010:           Vel]
type     = VelSet
trigger1 = Time = 0
y        = 0

[State 21010:           Pos]
type     = PosSet
trigger1 = Time = 0
y        = 0

[State 20010:           Turn]
type     = Turn
trigger1 = Time = 0
trigger1 = Root,Alive
trigger1 = RootDist X < 0
trigger2 = Vel X > 0
trigger2 = Root,Alive
trigger2 = RootDist X < Floor(-40 * const(size.xscale))
trigger3 = FrontEdgeBodyDist < Floor(-20 * const(size.xscale))

[State 20010:           Vel, 1]
type       = VelSet
trigger1   = Root,Alive
trigger1   = Abs(RootDist X) >= Ceil(80 * const(size.xscale))
trigger2   = !Root,Alive
trigger2   = FrontEdgeBodyDist > Floor(60 * const(size.xscale))
trigger2   = BackEdgeBodyDist < Floor(60 * const(size.xscale))
x          = Root,const(velocity.walk.fwd.x) * ifelse(Abs(RootDist X) > (960 * const(size.xscale)), 2.5, 1.25)
persistent = 1

[State 20010:           Vel, 2]
type       = VelSet
triggerall = Root,Alive
trigger1   = Abs(RootDist X) < Ceil(80 * const(size.xscale))
trigger1   = Abs(Root,Vel X) = [Root,const(velocity.walk.fwd.x) / 3, Root,const(velocity.walk.fwd.x) * 1.25]
x          = Abs(Root,Vel X)
persistent = 1

;-------[ States ]-------;

[State 20010:           Standing]
type       = ChangeState
triggerall = BackEdgeBodyDist >= Floor(60 * const(size.xscale)) || FrontEdgeBodyDist <= Floor(60 * const(size.xscale))
trigger1   = Root,Alive
trigger1   = Abs(Root,Vel X) <= (Root,const(velocity.walk.fwd.x) / 3)
trigger1   = Abs(RootDist X) < Ceil(80 * const(size.xscale))
trigger2   = Root,Alive = 0
value      = 21000

;------------------------------------------------------------------------------;
; ヒルダ 勝利
;------------------------------------------------------------------------------;
[Statedef 21100]
type        = A
movetype    = I
physics     = N
anim        = 21100
ctrl        = 0
sprpriority = -1
velset      = 0, 0

;-------[ Movement ]-------;

[State 21100:           Pos, 1]
type     = PosSet
trigger1 = Time = 0
y        = 0

[State 21100:           Vel, 1]
type     = VelSet
trigger1 = Time = 0
y        = -9 * Root,fvar(31)

[State 21100:           Vel, 2]
type     = VelMul
trigger1 = AnimElemTime(5) < 0
y        = 0.8

[State 21100:           Vel, 3]
type     = VelSet
trigger1 = AnimElem = 5
y        = 0

[State 21100:           Vel, 4]
type     = VelSet
trigger1 = AnimElemTime(5) > 0
y        = 0 - cos(AnimElemTime(5) * PI / 45) * (0.5 * Root,fvar(31))

;------------------------------------------------------------------------------;
; ヒルダ 敗北
;------------------------------------------------------------------------------;
[Statedef 21110]
type        = S
movetype    = I
physics     = S
anim        = 21110
ctrl        = 0
sprpriority = -1
velset      = 0, 0

;-------[ Movement ]-------;

[State 21100:           Pos, 1]
type     = PosSet
trigger1 = Time = 0
y        = 0


;==============================================================================;
; ヒルダ 攻撃
;==============================================================================;
;------------------------------------------------------------------------------;
; ヒルダ 攻撃 1
;------------------------------------------------------------------------------;
[Statedef 21200]
type        = S
movetype    = A
physics     = S
anim        = 21200
ctrl        = 0
facep2      = 1
sprpriority = 1

;-------[ Support Gauge ]-------;

[State 20200:           Support Gauge]
type     = ParentVarAdd
trigger1 = Time = 0
v        = 25
value    = -140

[State 20200:           Support Counter]
type       = ParentVarSet
triggerall = Root,MoveType = H
triggerall = Root,var(26) <= 0
trigger1   = Root,StateNo != 0              ; 以降ガード解除後にサポカンが発生するバグ対策
trigger1   = Root,StateNo != [10, 12]
trigger1   = Root,StateNo != 20
trigger1   = Root,StateNo != [40, 52]
trigger1   = Root,StateNo != [100, 119]
trigger1   = Root,StateNo != [120, 155]
trigger1   = Root,StateNo != [900, 930]
v          = 26
value      = 3 * TicksPerSecond

;-------[ Movement ]-------;

[State 21200:           Pos, 0]
type     = PosSet
trigger1 = Time = 0
y        = 0

[State 21200:           Vel, 0]
type     = VelSet
trigger1 = Time = 0
y        = 0

[State 21200:           State Type, 1]
type      = StateTypeSet
trigger1  = AnimElem = 2
statetype = C
movetype  = A
physics   = C

[State 21200:           State Type, 2]
type      = StateTypeSet
trigger1  = AnimElem = 4
statetype = S
movetype  = A
physics   = S

[State 21200:           State Type, 3]
type      = StateTypeSet
trigger1  = AnimElem = 5
statetype = A
movetype  = A
physics   = N

[State 21200:           Vel, 1]
type     = VelSet
trigger1 = AnimElem = 5
y        = -5 * Root,fvar(31)

[State 21200:           Gravity]
type     = Gravity
trigger1 = AnimElemTime(5) > 0

;-------[ Sounds ]-------;

[State 21200:           SE, 1]
type     = PlaySnd
trigger1 = AnimElem = 6
value    = 3, 82

;-------[ Projectiles ]-------;

[State 21200:           Knife, 1]
type        = Helper
trigger1    = AnimElemTime(6) = 0
helpertype  = Normal
name        = "Knife"
id          = 7570
stateno     = 7570
postype     = p1
pos         = 0, Floor(-230 * const(size.yscale))
size.xscale = const(size.xscale)
size.yscale = const(size.yscale)

[State 21200:           Knife, 1]
type        = Helper
trigger1    = AnimElemTime(6) = 4
helpertype  = Normal
name        = "Knife"
id          = 7571
stateno     = 7570
postype     = p1
pos         = 0, Floor(-230 * const(size.yscale))
size.xscale = const(size.xscale)
size.yscale = const(size.yscale)

[State 21200:           Knife, 1]
type        = Helper
trigger1    = AnimElemTime(6) = 8
helpertype  = Normal
name        = "Knife"
id          = 7572
stateno     = 7570
postype     = p1
pos         = 0, Floor(-230 * const(size.yscale))
size.xscale = const(size.xscale)
size.yscale = const(size.yscale)

;-------[ States ]-------;

[State 21200:           Landing]
type     = ChangeState
trigger1 = Vel Y > 0
trigger1 = Pos Y >= 0
value    = 21201

;------------------------------------------------------------------------------;
; ヒルダ 攻撃 1 着地
;------------------------------------------------------------------------------;
[Statedef 21201]
type        = S
movetype    = I
physics     = S
ctrl        = 0
sprpriority = 1

;-------[ Movement ]-------;

[State 21201:           Vel, 0]
type     = VelSet
trigger1 = Time = 0
y        = 0

[State 21201:           Pos, 0]
type     = PosSet
trigger1 = Time = 0
y        = 0

;------[ States ]------;

[State 21201:           Standing]
type     = ChangeState
trigger1 = Time = 0
value    = 21000

;------------------------------------------------------------------------------;
; ヒルダ 攻撃 2
;------------------------------------------------------------------------------;
[Statedef 21210]
type        = S
movetype    = I
physics     = S
anim        = 21210
ctrl        = 0
facep2      = 1
sprpriority = 1

;-------[ Support Gauge ]-------;

[State 20200:           Support Gauge]
type     = ParentVarAdd
trigger1 = Time = 0
v        = 25
value    = -170

[State 20200:           Support Counter]
type       = ParentVarSet
triggerall = Root,MoveType = H
triggerall = Root,var(26) <= 0
trigger1   = Root,StateNo != 0              ; 以降ガード解除後にサポカンが発生するバグ対策
trigger1   = Root,StateNo != [10, 12]
trigger1   = Root,StateNo != 20
trigger1   = Root,StateNo != [40, 52]
trigger1   = Root,StateNo != [100, 119]
trigger1   = Root,StateNo != [120, 155]
trigger1   = Root,StateNo != [900, 930]
v          = 26
value      = 5 * TicksPerSecond

;-------[ Movement ]-------;

[State 21200:           Pos, 0]
type     = PosSet
trigger1 = Time = 0
y        = 0

[State 21200:           Vel, 0]
type     = VelSet
trigger1 = Time = 0
y        = 0

;-------[ States ]-------;

[State 21200:           Anim, 1]
type     = ChangeAnim
trigger1 = AnimTime = 0
trigger1 = NumHelper(21500)
trigger1 = Helper(21500),StateNo = 21500
value    = 21000

[State 21200:           Standing]
type       = ChangeState
triggerall = AnimTime = 0
trigger1   = NumHelper(21500)
trigger1   = Helper(21500),StateNo != 21500
trigger2   = !NumHelper(21500)
value      = 21000

;------------------------------------------------------------------------------;
; ヒルダ 攻撃 3
;------------------------------------------------------------------------------;
[Statedef 21220]
type        = S
movetype    = I
physics     = S
anim        = 21210
ctrl        = 0
facep2      = 1
sprpriority = 1

;-------[ Support Gauge ]-------;

[State 20200:           Support Gauge]
type     = ParentVarAdd
trigger1 = Time = 0
v        = 25
value    = -190

[State 20200:           Support Counter]
type       = ParentVarSet
triggerall = Root,MoveType = H
triggerall = Root,var(26) <= 0
trigger1   = Root,StateNo != 0              ; 以降ガード解除後にサポカンが発生するバグ対策
trigger1   = Root,StateNo != [10, 12]
trigger1   = Root,StateNo != 20
trigger1   = Root,StateNo != [40, 52]
trigger1   = Root,StateNo != [100, 119]
trigger1   = Root,StateNo != [120, 155]
trigger1   = Root,StateNo != [900, 930]
v          = 26
value      = 6 * TicksPerSecond

;-------[ Movement ]-------;

[State 21200:           Pos, 0]
type     = PosSet
trigger1 = Time = 0
y        = 0

[State 21200:           Vel, 0]
type     = VelSet
trigger1 = Time = 0
y        = 0

;-------[ States ]-------;

[State 21200:           Anim, 1]
type     = ChangeAnim
trigger1 = AnimTime = 0
trigger1 = NumHelper(21500)
trigger1 = Helper(21500),StateNo = 21510
value    = 21000

[State 21200:           Standing]
type       = ChangeState
triggerall = AnimTime = 0
trigger1   = NumHelper(21500)
trigger1   = Helper(21500),StateNo != 21510
trigger2   = !NumHelper(21500)
value      = 21000

;------------------------------------------------------------------------------;
; ヒルダ 攻撃 4
;------------------------------------------------------------------------------;
[Statedef 21230]
type        = S
movetype    = A
physics     = S
anim        = 21230
ctrl        = 0
facep2      = 1
sprpriority = 1

;-------[ Support Gauge ]-------;

[State 20200:           Support Gauge]
type     = ParentVarAdd
trigger1 = Time = 0
v        = 25
value    = -290

[State 20200:           Support Counter]
type       = ParentVarSet
triggerall = Root,MoveType = H
triggerall = Root,var(26) <= 0
trigger1   = Root,StateNo != 0              ; 以降ガード解除後にサポカンが発生するバグ対策
trigger1   = Root,StateNo != [10, 12]
trigger1   = Root,StateNo != 20
trigger1   = Root,StateNo != [40, 52]
trigger1   = Root,StateNo != [100, 119]
trigger1   = Root,StateNo != [120, 155]
trigger1   = Root,StateNo != [900, 930]
v          = 26
value      = 6 * TicksPerSecond

;-------[ Movement ]-------;

[State 21230:           Pos, 0]
type     = PosSet
trigger1 = Time = 0
y        = 0

[State 21230:           Vel, 0]
type     = VelSet
trigger1 = Time = 0
x        = 0
y        = 0

[State 21230:           State Type, 1]
type      = StateTypeSet
trigger1  = AnimElem = 5
statetype = A
movetype  = A
physics   = N

[State 20230:           Vel, 1]
type     = VelSet
trigger1 = AnimElem = 5
x        = 0
y        = -8.8 * Root,fvar(31)

[State 20230:           Vel, 2]
type     = VelSet
trigger1 = AnimElem = 6
y        = 0

[State 20230:           Vel, 4, Gravity, 1]
type     = VelMul
trigger1 = AnimElemTime(6) < 0
y        = 0.9

[State 20230:           Vel, 3, Gravity]
type     = VelAdd
trigger1 = Time > (39 + (12 * 4))
y        = 0.35 * Root,fvar(31)

;-------[ Sounds ]-------;

[State 20230:           SE, 1]
type     = PlaySnd
trigger1 = AnimElem = 5
value    = 3, 61

;-------[ Effects ]-------;

[State 20230:           Beam]
type        = Explod
trigger1    = AnimElem = 7
anim        = 7590
postype     = p1
pos         = 0, 0
ownpal      = 1
sprpriority = 3
scale       = const(size.xscale), const(size.yscale)

;-------[ Projectiles ]-------;

[State 20230:           Explosion, 1]
type        = Helper
trigger1    = Time = 56
helpertype  = Normal
name        = "Explosion"
stateno     = 7541
id          = 7549
postype     = p1
pos         = Floor(-400 * const(size.xscale)), 0
ownpal      = 1
size.xscale = const(size.xscale)
size.yscale = const(size.yscale)

[State 20230:           Explosion, 2]
type        = Helper
trigger1    = Time = 60
helpertype  = Normal
name        = "Explosion"
stateno     = 7541
id          = 7549
postype     = p1
pos         = Floor(-320 * const(size.xscale)), 0
ownpal      = 1
size.xscale = const(size.xscale)
size.yscale = const(size.yscale)

[State 20230:           Explosion, 3]
type        = Helper
trigger1    = Time = 64
helpertype  = Normal
name        = "Explosion"
stateno     = 7541
id          = 7549
postype     = p1
pos         = Floor(-240 * const(size.xscale)), 0
ownpal      = 1
size.xscale = const(size.xscale)
size.yscale = const(size.yscale)

[State 20230:           Explosion, 4]
type        = Helper
trigger1    = Time = 68
helpertype  = Normal
name        = "Explosion"
stateno     = 7541
id          = 7549
postype     = p1
pos         = Floor(-80 * const(size.xscale)), 0
ownpal      = 1
size.xscale = const(size.xscale)
size.yscale = const(size.yscale)

[State 20230:           Explosion, 5]
type        = Helper
trigger1    = Time = 72
helpertype  = Normal
name        = "Explosion"
stateno     = 7541
id          = 7549
postype     = p1
pos         = Floor(80 * const(size.xscale)), 0
ownpal      = 1
size.xscale = const(size.xscale)
size.yscale = const(size.yscale)

[State 20230:           Explosion, 6]
type        = Helper
trigger1    = Time = 76
helpertype  = Normal
name        = "Explosion"
stateno     = 7541
id          = 7549
postype     = p1
pos         = Floor(240 * const(size.xscale)), 0
ownpal      = 1
size.xscale = const(size.xscale)
size.yscale = const(size.yscale)

[State 20230:           Explosion, 7]
type        = Helper
trigger1    = Time = 80
helpertype  = Normal
name        = "Explosion"
stateno     = 7541
id          = 7549
postype     = p1
pos         = Floor(320 * const(size.xscale)), 0
ownpal      = 1
size.xscale = const(size.xscale)
size.yscale = const(size.yscale)

[State 20230:           Explosion, 8]
type        = Helper
trigger1    = Time = 84
helpertype  = Normal
name        = "Explosion"
stateno     = 7541
id          = 7549
postype     = p1
pos         = Floor(400 * const(size.xscale)), 0
ownpal      = 1
size.xscale = const(size.xscale)
size.yscale = const(size.yscale)

[State 20230:           Explosion, 9]
type        = Helper
trigger1    = Time = 88
helpertype  = Normal
name        = "Explosion"
stateno     = 7541
id          = 7549
postype     = p1
pos         = Floor(480 * const(size.xscale)), 0
ownpal      = 1
size.xscale = const(size.xscale)
size.yscale = const(size.yscale)

;-------[ States ]-------;

[State 20230:           Landing]
type     = ChangeState
trigger1 = Vel Y > 0
trigger1 = Pos Y >= 0
value    = 21201


;==============================================================================;
; ヒルダ プロクシガード
;==============================================================================;
;------------------------------------------------------------------------------;
; ヒルダ プロクシガード 発生
;------------------------------------------------------------------------------;
[Statedef 21300]
type        = S
movetype    = I
physics     = S
anim        = 21210
ctrl        = 0
facep2      = 1
sprpriority = 0

;-------[ Support Gauge ]-------;

[State 20200:           Support Gauge]
type     = ParentVarAdd
trigger1 = Time = 0
v        = 25
value    = -10

[State 20200:           Support Counter]
type       = ParentVarSet
triggerall = NumHelper(21500)
triggerall = Helper(21500),PrevStateNo != 21521
triggerall = Root,MoveType = H
triggerall = Root,var(26) <= 0
trigger1   = Root,StateNo != 0              ; 以降ガード解除後にサポカンが発生するバグ対策
trigger1   = Root,StateNo != [10, 12]
trigger1   = Root,StateNo != 20
trigger1   = Root,StateNo != [40, 52]
trigger1   = Root,StateNo != [100, 119]
trigger1   = Root,StateNo != [120, 155]
v          = 26
value      = 3 * TicksPerSecond

;-------[ Movement ]-------;

[State 21200:           Pos, 0]
type     = PosSet
trigger1 = Time = 0
y        = 0

[State 21200:           Vel, 0]
type     = VelSet
trigger1 = Time = 0
y        = 0

;-------[ Anim ]-------;

[State 21200:           Anim, 1]
type     = ChangeAnim
trigger1 = AnimTime = 0
trigger1 = NumHelper(21500)
trigger1 = Helper(21500),StateNo = [21520, 21521]
value    = 21000

;-------[ States ]-------;

[State 21200:           Standing]
type       = ChangeState
triggerall = AnimTime = 0
trigger1   = NumHelper(21500)
trigger1   = Helper(21500),StateNo != [21520, 21521]
trigger2   = !NumHelper(21500)
value      = 21000


;==============================================================================;
; サポート マーヤ & カーヤ
;==============================================================================;
;------------------------------------------------------------------------------;
; 攻撃 2
;------------------------------------------------------------------------------;
[Statedef 21500]
type        = S
movetype    = A
physics     = N
anim        = 9999
ctrl        = 0
sprpriority = 0

;-------[ Anim ]-------;

[State 21520:           Remove Small Maya]
type     = RemoveExplod
trigger1 = Time = 0
id       = 21550

[State 21520:           Remove Small Kaya]
type     = RemoveExplod
trigger1 = Time = 0
id       = 21650

;-------[ Effects ]-------;

[State 21500:           Effect, 1]
type          = Helper
trigger1      = Time = 0
helpertype    = Normal
name          = "Maya Light"
stateno       = 7560
id            = 7560
postype       = p1
pos           = Floor(52 * const(size.xscale)), Floor(-209 * const(size.yscale))
ownpal        = 1
size.xscale   = const(size.xscale)
size.yscale   = const(size.yscale)
supermovetime = 24
pausemovetime = 24

[State 21500:           Effect, 2]
type          = Helper
trigger1      = Time = 0
helpertype    = Normal
name          = "Kaya Light"
stateno       = 7560
id            = 7561
postype       = p1
pos           = Floor(-72 * const(size.xscale)), Floor(-206 * const(size.yscale))
ownpal        = 1
size.xscale   = const(size.xscale)
size.yscale   = const(size.yscale)
supermovetime = 24
pausemovetime = 24

;-------[ Movement ]-------;

[State 21500:           Bind]
type     = BindToParent
trigger1 = Time = 0
pos      = 0, 0
facing   = 1
time     = 1

;-------[ Sounds ]-------;

[State 21500:           SE, 1]
type     = PlaySnd
trigger1 = Time = 8
trigger2 = Time = 30
value    = 6, 2

[State 21500:           SE, 2]
type     = PlaySnd
trigger1 = Time = 11
trigger2 = Time = 33
value    = 7, 14

;-------[ Maya & Kaya ]-------;

[State 21500:           Kaya]
type        = Explod
trigger1    = Time = 0
anim        = 21600
id          = 21600
postype     = p1
pos         = Floor(80 * const(size.xscale)), 0
ownpal      = 0
scale       = const(size.xscale), const(size.yscale)
sprpriority = 1
shadow      = -1

[State 21500:           Maya]
type        = Explod
trigger1    = Time = 26
anim        = 21500
id          = 21500
postype     = p1
pos         = Floor(280 * const(size.xscale)), 0
ownpal      = 0
scale       = const(size.xscale), const(size.yscale)
sprpriority = 1
shadow      = -1

[State 21500:           Explod]
type       = Explod
trigger1   = Time = 11
anim       = 6110
postype    = p1
pos        = Floor(244 * const(size.xscale)), 0
scale      = const(size.xscale), const(size.yscale)
ownpal     = 1
sprpriority = -1

[State 21500:           Explod, 2]
type       = Explod
trigger1   = Time = 33
anim       = 6110
postype    = p1
pos        = Floor(360 * const(size.xscale)), 0
scale      = const(size.xscale), const(size.yscale)
ownpal     = 1
sprpriority = -1

[State 21500:           Projectile, 1, Kaya]
type             = Projectile
trigger1         = Time = 0
projid           = 21600
projanim         = 21601
projhitanim      = -1
projremanim      = -1
projremove       = 1
projremovetime   = 14
projhits         = 1
projpriority     = 1
projsprpriority  = 10
projedgebound    = Floor(240 * const(size.xscale))
projstagebound   = Floor(240 * const(size.xscale))
offset           = Floor(80 * const(size.xscale)), 0
velocity         = Vel X, Vel Y
animtype         = Diagup
attr             = S, NA
damage           = 50, 0
hitflag          = MAF
guardflag        = MA
pausetime        = 0, 8
sparkno          = S6000 + Random % 8
guard.sparkno    = S6061
sparkxy          = Floor(220 * const(size.xscale)), Floor(-170 * const(size.yscale))
hitsound         = S7, 2
guardsound       = S8, 0
ground.type      = Low
ground.hittime   = 17
ground.slidetime = 16
ground.velocity  = -3 * Root,fvar(31), -4 * Root,fvar(31)
guard.ctrltime   = 15
air.hittime      = 16
air.velocity     = -3 * Root,fvar(31), -3 * Root,fvar(31)
air.juggle       = ifelse((Root,var(20) > 0), 1, 3)
fall             = 1
air.fall         = 1
fall.recover     = 1
fall.recovertime = 35
id               = 21600

[State 21500:           Projectile, 2, Maya]
type             = Projectile
trigger1         = Time = 26
projid           = 21500
projanim         = 21501
projhitanim      = -1
projremanim      = -1
projremove       = 1
projremovetime   = 14
projhits         = 1
projpriority     = 1
projsprpriority  = 10
projedgebound    = Floor(240 * const(size.xscale))
projstagebound   = Floor(240 * const(size.xscale))
offset           = Floor(280 * const(size.xscale)), 0
velocity         = Vel X, Vel Y
animtype         = Hard
attr             = S, NA
damage           = 19, 0
hitflag          = MAF
guardflag        = MA
pausetime        = 0, 8
sparkno          = S6000 + Random % 8
guard.sparkno    = S6061
sparkxy          = Floor(90 * const(size.xscale)), Floor(-150 * const(size.yscale))
hitsound         = S7, 2
guardsound       = S8, 0
ground.type      = Low
ground.hittime   = 19
ground.slidetime = 18
ground.velocity  = -4 * Root,fvar(31), -4 * Root,fvar(31)
guard.ctrltime   = 17
air.hittime      = 19
air.velocity     = -4 * Root,fvar(31), -3 * Root,fvar(31)
air.juggle       = ifelse((Root,var(20) > 0), 1, 3)
fall             = 1
air.fall         = 1
fall.recover     = 0
id               = 21500
nochainid        = 21600

;-------[ States ]-------;

[State 21500:           Wait]
type       = ChangeState
triggerall = Time > 0
trigger1   = !NumExplod(21500)
trigger1   = !NumExplod(21600)
value      = 21550

;------------------------------------------------------------------------------;
; 攻撃 3
;
; fvar(0)   : MayaのX速度
; fvar(1)   : MayaのY速度
; fvar(2)   : KayaのX速度
; fvar(3)   : KayaのY速度
; fvar(10)  : MayaのX位置
; fvar(11)  : MayaのY位置
; fvar(12)  : KayaのX位置
; fvar(13)  : KayaのY位置
;------------------------------------------------------------------------------;
[Statedef 21510]
type        = S
movetype    = A
physics     = N
anim        = 9999
ctrl        = 0
sprpriority = 0

;-------[ Init ]-------;

[State 21510:           Reset Pos, 0]
type     = VarSet
trigger1 = Time = 0
fv       = 10
value    = 0

[State 21510:           Reset Pos, 0]
type     = VarSet
trigger1 = Time = 0
fv       = 11
value    = 0

[State 21510:           Reset Pos, 0]
type     = VarSet
trigger1 = Time = 0
fv       = 12
value    = 0

[State 21510:           Reset Pos, 0]
type     = VarSet
trigger1 = Time = 0
fv       = 13
value    = 0

[State 21510:           Reset Vel, 0]
type     = VelSet
trigger1 = Time = 0
fv       = 0
value    = 0

[State 21510:           Reset Vel, 0]
type     = VelSet
trigger1 = Time = 0
fv       = 1
value    = 0

[State 21510:           Reset Vel, 0]
type     = VelSet
trigger1 = Time = 0
fv       = 2
value    = 0

[State 21510:           Reset Vel, 0]
type     = VelSet
trigger1 = Time = 0
fv       = 3
value    = 0

;-------[ Anim ]-------;

[State 21520:           Remove Small Maya]
type     = RemoveExplod
trigger1 = Time = 0
id       = 21550

[State 21520:           Remove Small Kaya]
type     = RemoveExplod
trigger1 = Time = 0
id       = 21650

;-------[ Effects ]-------;

[State 21500:           Effect, 1]
type          = Helper
trigger1      = Time = 0
helpertype    = Normal
name          = "Maya Light"
stateno       = 7560
id            = 7560
postype       = p1
pos           = Floor(52 * const(size.xscale)), Floor(-209 * const(size.yscale))
ownpal        = 1
size.xscale   = const(size.xscale)
size.yscale   = const(size.yscale)
supermovetime = 24
pausemovetime = 24

[State 21500:           Effect, 2]
type          = Helper
trigger1      = Time = 0
helpertype    = Normal
name          = "Kaya Light"
stateno       = 7560
id            = 7561
postype       = p1
pos           = Floor(-72 * const(size.xscale)), Floor(-206 * const(size.yscale))
ownpal        = 1
size.xscale   = const(size.xscale)
size.yscale   = const(size.yscale)
supermovetime = 24
pausemovetime = 24

;-------[ Movement ]-------;

[State 21500:           Bind]
type     = BindToParent
trigger1 = Time = 0
pos      = 0, 0
facing   = 1
time     = 1

;-------[ Sounds ]-------;

[State 21500:           SE, 1]
type     = PlaySnd
trigger1 = Time = 7
value    = 6, 5

[State 21500:           SE, 2]
type     = PlaySnd
trigger1 = Time = 35
value    = 6, 2

;-------[ Maya ]-------;

[State 21500:           Vel, X]
type     = VarSet
trigger1 = Time = 7
fv       = 0
value    = 2 * Root,fvar(31)

[State 21500:           Vel, Y]
type     = VarSet
trigger1 = Time = 7
fv       = 1
value    = -9 * Root,fvar(31)

[State 21500:           Vel, X]
type     = VarSet
trigger1 = Time > 7
fv       = 0
value    = fvar(0) * 0.9

[State 21500:           Vel, Y]
type     = VarSet
trigger1 = Time > 7
fv       = 1
value    = fvar(1) * 0.9

[State 21500:           Vel X]
type     = VarSet
trigger1 = fvar(0) > 0 && fvar(0) <= (0.2 * Root,fvar(31))
fv       = 0
value    = 0

[State 21500:           Vel Y]
type     = VarSet
trigger1 = fvar(1) > 0 && fvar(1) <= (0.2 * Root,fvar(31))
fv       = 1
value    = 0

[State 21500:           Pos, X]
type     = VarAdd
trigger1 = 1
fv       = 10
value    = Ceil(fvar(0))

[State 21500:           Pos, Y]
type     = VarAdd
trigger1 = 1
fv       = 11
value    = Ceil(fvar(1))

[State 21500:           Maya]
type        = Explod
trigger1    = Time = 0
anim        = 21510
id          = 21500
postype     = p1
pos         = Floor(80 * const(size.xscale)), 0
ownpal      = 0
sprpriority = 1
scale       = const(size.xscale), const(size.yscale)
shadow      = -1

[State 21500:           Maya Control]
type     = ModifyExplod
trigger1 = NumExplod(21500)
trigger1 = Time < 34
postype  = p1
pos      = Floor(80 * const(size.xscale) + fvar(10)), Floor(fvar(11))
id       = 21500

[State 21500:           Projectile, 1, Maya]
type             = Projectile
trigger1         = Time = 7
projid           = 21510
projanim         = 21511
projhitanim      = -1
projremanim      = -1
projremove       = 1
projremovetime   = 12
projhits         = 1
projpriority     = 1
projsprpriority  = 10
projedgebound    = Floor(240 * const(size.xscale))
projstagebound   = Floor(240 * const(size.xscale))
offset           = Floor(80 * const(size.xscale) + fvar(10)), Floor(fvar(11))
velocity         = fvar(0), fvar(1)
velmul           = 0.9, 0.9
animtype         = Up
attr             = A, NA
damage           = 55, 0
hitflag          = MAF
guardflag        = MA
pausetime        = 0, 8
sparkno          = S6000 + Random % 8
guard.sparkno    = S6061
sparkxy          = Floor(60 * const(size.xscale)), Floor(-180 * const(size.yscale))
hitsound         = S7, 5
guardsound       = S8, 0
ground.type      = High
ground.hittime   = 19
ground.slidetime = 18
ground.velocity  = -2 * Root,fvar(31), -8 * Root,fvar(31)
air.hittime      = 19
air.velocity     = -2 * Root,fvar(31), -6 * Root,fvar(31)
air.juggle       = ifelse((Root,var(20) > 0), 1, 3)
fall             = 1
air.fall         = 1
fall.recover     = 1
fall.recovertime = 45
id               = 21510

;-------[ Kaya ]-------;

[State 21500:           Vel, X]
type     = VarSet
trigger1 = Time = 33
fv       = 2
value    = 0

[State 21500:           Vel, Y]
type     = VarSet
trigger1 = Time = 33
fv       = 3
value    = 4 * Root,fvar(31)

[State 21500:           Vel, X]
type     = VarSet
trigger1 = Time > 33
trigger1 = fvar(2) > (0.2 * Root,fvar(31))
fv       = 2
value    = fvar(2) * 0.9

[State 21500:           Vel, Y]
type     = VarSet
trigger1 = Time > 33
trigger1 = fvar(3) > (0.2 * Root,fvar(31))
fv       = 3
value    = fvar(3) * 0.9

[State 21500:           Vel X]
type     = VarSet
trigger1 = fvar(2) >= 0 && fvar(2) <= (0.2 * Root,fvar(31))
fv       = 2
value    = 0

[State 21500:           Vel Y]
type     = VarSet
trigger1 = fvar(3) >= 0 && fvar(3) <= (0.2 * Root,fvar(31))
fv       = 3
value    = 0

[State 21500:           Pos, X]
type     = VarAdd
trigger1 = 1
fv       = 12
value    = Ceil(fvar(2))

[State 21500:           Pos, Y]
type     = VarAdd
trigger1 = 1
fv       = 13
value    = Ceil(fvar(3))

[State 21500:           Kaya]
type        = Explod
trigger1    = Time = 25
anim        = 21610
id          = 21600
postype     = p1
pos         = Floor(280 * const(size.xscale)), Floor(-220 * const(size.yscale))
ownpal      = 0
sprpriority = 1
scale       = const(size.xscale), const(size.yscale)
shadow      = -1

[State 21500:           Maya Control]
type     = ModifyExplod
trigger1 = NumExplod(21600)
trigger1 = Time < 55
postype  = p1
pos      = Floor(280 * const(size.xscale) + fvar(12)), Floor(-220 * const(size.yscale) + fvar(13))
id       = 21600

[State 21500:           Projectile, 2, Kaya]
type             = Projectile
trigger1         = Time = 33
projid           = 21610
projanim         = 21611
projhitanim      = -1
projremanim      = -1
projremove       = 1
projremovetime   = 8
projhits         = 1
projpriority     = 1
projsprpriority  = 10
projedgebound    = Floor(240 * const(size.xscale))
projstagebound   = Floor(240 * const(size.xscale))
offset           = Floor(280 * const(size.xscale) + fvar(12)), Floor(-220 * const(size.yscale) + fvar(13))
velocity         = fvar(2), fvar(3)
velmul           = 0.9, 0.9
animtype         = Hard
attr             = A, NA
damage           = 26, 0
hitflag          = HAF
guardflag        = HA
pausetime        = 0, 8
sparkno          = S6000 + Random % 8
guard.sparkno    = S6061
sparkxy          = Floor(-55 * const(size.xscale)), Floor(-80 * const(size.yscale))
hitsound         = S7, 2
guardsound       = S8, 0
ground.type      = High
ground.hittime   = 19
ground.slidetime = 18
ground.velocity  = -1 * Root,fvar(31), 9 * Root,fvar(31)
air.hittime      = 19
air.velocity     = -1 * Root,fvar(31), 9 * Root,fvar(31)
air.juggle       = ifelse((Root,var(20) > 0), 1, 3)
fall             = 1
air.fall         = 1
fall.recover     = 0
id               = 21610

;-------[ States ]-------;

[State 21500:           Wait]
type       = ChangeState
triggerall = Time > 0
trigger1   = !NumExplod(21500)
trigger1   = !NumExplod(21600)
value      = 21550

;------------------------------------------------------------------------------;
; プロクシガード
;------------------------------------------------------------------------------;
[Statedef 21520]
type        = S
movetype    = A
physics     = S
anim        = 21520
ctrl        = 0
sprpriority = 1

;-------[ Anim ]-------;

[State 21520:           Remove Small Maya]
type     = RemoveExplod
trigger1 = Time = 0
id       = 21550

[State 21520:           Remove Small Kaya]
type     = RemoveExplod
trigger1 = Time = 0
id       = 21650

;-------[ Effects ]-------;

[State 21500:           Effect, 1]
type          = Helper
trigger1      = Time = 0
trigger1      = PrevStateNo != 21521
helpertype    = Normal
name          = "Maya Light"
stateno       = 7560
id            = 7560
postype       = p1
pos           = Floor(52 * const(size.xscale)), Floor(-209 * const(size.yscale))
ownpal        = 1
size.xscale   = const(size.xscale)
size.yscale   = const(size.yscale)
supermovetime = 24
pausemovetime = 24

[State 21500:           Effect, 2]
type          = Helper
trigger1      = Time = 0
trigger1      = PrevStateNo != 21521
helpertype    = Normal
name          = "Kaya Light"
stateno       = 7560
id            = 7561
postype       = p1
pos           = Floor(-72 * const(size.xscale)), Floor(-206 * const(size.yscale))
ownpal        = 1
size.xscale   = const(size.xscale)
size.yscale   = const(size.yscale)
supermovetime = 24
pausemovetime = 24

;-------[ Movement ]-------;

[State 21520:           Dist]
type     = AttackDist
trigger1 = AnimElemTime(2) < 0
value    = 0
facing   = 1

[State 21520:           Pos, 1]
type     = BindToParent
trigger1 = Time = 0
pos      = Floor(80 * const(size.xscale)), 0

[State 21520:           State Type, 1]
type     = StateTypeSet
trigger1 = AnimElem = 2
movetype = I

[State 20300:           Hit, 1]
type     = HitBy
trigger1 = AnimElemTime(2) < 0
value    = SCA, NP, SP, HP
time     = 1

[State 20300:           Hit, 2]
type     = NotHitBy
trigger1 = AnimElemTime(2) >= 0
value    = SCA, NA, SA, HA, NT, ST, HT, NP, SP, HP
time     = 1

;-------[ Effects ]-------;

[State 20300:           Effects]
type        = Explod
trigger1    = Time = 0
anim        = 7600
postype     = p1
pos         = Floor(7 * const(size.xscale)), Floor(-253 * const(size.yscale))
ownpal      = 1
bindtime    = -1
scale       = const(size.xscale), const(size.yscale)
sprpriority = 2

;-------[ Sounds ]--------;

[State 20300:           SE, 1]
type     = PlaySnd
trigger1 = Time = 0
value    = 3, 74

;-------[ Hit Defs ]-------;

[State 20300:           Reversal]
type          = ReversalDef
trigger1      = Time = 0
attr          = S, NA
reversal.attr = SCA, NP, SP, HP
sparkno       = -1
sparkxy       = 0, 0
hitsound      = -1  ;S3, 122
p1stateno     = 21521

[State 20300:           Hit Override]
type     = HitOverride
trigger1 = AnimElemTime(2) < 0
attr     = SCA, NP, SP, HP
slot     = 1
stateno  = 21521
time     = 2

;-------[ States ]-------;

[State 21520:           Waiting]
type     = ChangeState
trigger1 = AnimTime = 0
value    = 21550

;------------------------------------------------------------------------------;
; プロクシガード 成立
;------------------------------------------------------------------------------;
[Statedef 21521]
type        = S
movetype    = I
physics     = S
anim        = 21521
ctrl        = 0
vel         = 0, 0
sprpriority = 1

;-------[ Effects ]-------;

[State 20301:           Pal, 1]
type     = PalFX
trigger1 = Time = 0
add      = 255, 255, 255
time     = 4

;-------[ Sounds ]-------;

[State 20301:           SE, 1]
type     = PlaySnd
trigger1 = Time = 0
value    = 3, 122
channel  = 3

;-------[ Movement ]-------;

[State 20301:           Pause]
type     = Pause
trigger1 = Time = 0
time     = 15
movetime = 15

;-------[ States ]-------;

[State 20301:           Proxy]
type     = ChangeState
trigger1 = Time = 15
trigger1 = Root,var(25) > 0
value    = 21520

[State 20301:           No Gauge]
type     = ChangeAnim
trigger1 = Time = 15
value    = 21520
elem     = 2

[State 20301:           Return Standing]
type     = ChangeState
trigger1 = Anim = 21520
trigger1 = AnimTime = 0
value    = 21550

;------------------------------------------------------------------------------;
; 待機
;------------------------------------------------------------------------------;
[Statedef 21550]
type     = A
movetype = I
physics  = N
anim     = 9999
ctrl     = 0

;-------[ Bind to Parent ]-------;

[State 21550:           Bind]
type     = BindToParent
trigger1 = 1
pos      = 0, 0

;-------[ Effects ]-------;

[State 21500:           Effect, 1]
type        = Helper
triggerall  = PrevStateNo != 21560
trigger1    = Time = 1
helpertype  = Normal
name        = "Maya Light"
stateno     = 7560
id          = 7560
postype     = p1
pos         = Floor(52 * const(size.xscale)), Floor(-209 * const(size.yscale))
ownpal      = 1
size.xscale = const(size.xscale)
size.yscale = const(size.yscale)
persistent  = 0

[State 21500:           Effect, 2]
type        = Helper
triggerall  = PrevStateNo != 21560
trigger1    = Time = 1
helpertype  = Normal
name        = "Kaya Light"
stateno     = 7560
id          = 7561
postype     = p1
pos         = Floor(-72 * const(size.xscale)), Floor(-206 * const(size.yscale))
ownpal      = 1
size.xscale = const(size.xscale)
size.yscale = const(size.yscale)
persistent  = 0

;-------[ Anim Rest ]-------;

[State 21550:           Reset Maya]
type       = RemoveExplod
triggerall = NumExplod(21550)
trigger1   = Parent,Facing != Facing
trigger2   = Time = 0
id         = 21550

[State 21550:           Reset Kaya]
type       = RemoveExplod
triggerall = NumExplod(21650)
trigger1   = Parent,Facing != Facing
trigger2   = Time = 0
id         = 21650

;-------[ Movement ]-------;

[State 21550:           Turn]
type     = Turn
trigger1 = Parent,Facing != Facing

;-------[ Anim ]-------;

[State 21550:           Maya]
type        = Explod
trigger1    = !NumExplod(21550)
anim        = 21550
id          = 21550
postype     = p1
pos         = Floor(52 * const(size.xscale)), Floor(-209 * const(size.yscale))
scale       = const(size.xscale), const(size.yscale)
ownpal      = 1
bindtime    = -1
removetime = -1
sprpriority = -2
shadow      = -1

[State 21550:           Kaya]
type        = Explod
trigger1    = !NumExplod(21650)
anim        = 21650
id          = 21650
postype     = p1
pos         = Floor(-72 * const(size.xscale)), Floor(-206 * const(size.yscale))
scale       = const(size.xscale), const(size.yscale)
ownpal      = 1
bindtime    = -1
removetime = -1
sprpriority = -2
shadow      = -1

;-------[ Staets ]-------;

[State 21550:           ChangeState, Walk]
type       = ChangeState
trigger1   = Parent,StateNo = 21010
value      = 21560
persistent = 1

[State 21550:           ChangeState, Lose]
type       = ChangeState
trigger1   = Parent,StateNo = 21110
value      = 21570
persistent = 1

[State 21550:           Attack, 2]
type       = ChangeState
trigger1   = Parent,StateNo = 21210
trigger1   = Parent,Time = 1
value      = 21500
persistent = 1

[State 21550:           Attack, 3]
type       = ChangeState
trigger1   = Parent,StateNo = 21220
trigger1   = Parent,Time = 1
value      = 21510
persistent = 1

[State 21550:           Attack, 4]
type       = ChangeState
trigger1   = Parent,StateNo = 21230
trigger1   = Parent,Time = 1
value      = 21590
persistent = 1

[State 21550:           Proxy Guard]
type       = ChangeState
trigger1   = Parent,StateNo = 21300
trigger1   = Parent,Time = 1
value      = 21520
persistent = 1

;------------------------------------------------------------------------------;
; 移動
;------------------------------------------------------------------------------;
[Statedef 21560]
type     = A
movetype = I
physics  = N
anim     = 9999
ctrl     = 0

;-------[ Reset Anim ]-------;

[State 21550:           Reset Maya]
type     = RemoveExplod
trigger1 = Time = 0
trigger2 = Parent,Facing != Facing
id       = 21550

[State 21550:           Reset Kaya]
type     = RemoveExplod
trigger1 = Time = 0
trigger2 = Parent,Facing != Facing
id       = 21650

;-------[ Movement ]-------;

[State 21550:           Bind]
type     = BindToParent
trigger1 = 1
pos      = 0, 0

[State 21550:           Turn]
type     = Turn
trigger1 = Parent,Facing != Facing

;-------[ Anim ]-------;

[State 21550:           Maya]
type        = Explod
trigger1    = !NumExplod(21550)
anim        = 21560
id          = 21550
postype     = p1
pos         = Floor(72 * const(size.xscale)), Floor(-194 * const(size.yscale))
scale       = const(size.xscale), const(size.yscale)
ownpal      = 1
bindtime    = -1
removetime = -1
sprpriority = -2
shadow      = -1

[State 21550:           Kaya]
type        = Explod
trigger1    = !NumExplod(21650)
anim        = 21660
id          = 21650
postype     = p1
pos         = Floor(-59 * const(size.xscale)), Floor(-193 * const(size.yscale))
scale       = const(size.xscale), const(size.yscale)
ownpal      = 1
bindtime    = -1
removetime = -1
sprpriority = -2
shadow      = -1

;-------[ Staets ]-------;

[State 21550:           ChangeState, Wait]
type       = ChangeState
trigger1   = Parent,StateNo != 21010
value      = 21550
persistent = 1

[State 21550:           Attack, 2]
type       = ChangeState
trigger1   = Parent,StateNo = 21210
trigger1   = Parent,AnimElem = 1
value      = 21500
persistent = 1

[State 21550:           Attack, 3]
type       = ChangeState
trigger1   = Parent,StateNo = 21220
trigger1   = Parent,AnimElem = 1
value      = 21510
persistent = 1

[State 21550:           Attack, 4]
type       = ChangeState
trigger1   = Parent,StateNo = 21230
value      = 21590
persistent = 1

[State 21550:           Proxy Guard]
type       = ChangeState
trigger1   = Parent,StateNo = 21300
trigger1   = Parent,AnimElem = 1
value      = 21520
persistent = 1

;------------------------------------------------------------------------------;
; 敗北
;------------------------------------------------------------------------------;
[Statedef 21570]
type     = A
movetype = I
physics  = N
anim     = 9999
ctrl     = 0

;-------[ Anim Rest ]-------;

[State 21550:           Reset Maya]
type       = RemoveExplod
triggerall = NumExplod(21550)
trigger1   = Parent,Facing != Facing
trigger2   = Time = 0
id         = 21550

[State 21550:           Reset Kaya]
type       = RemoveExplod
triggerall = NumExplod(21650)
trigger1   = Parent,Facing != Facing
trigger2   = Time = 0
id         = 21650

;-------[ Movement ]-------;

[State 21550:           Bind]
type     = BindToParent
trigger1 = 1
pos      = 0, 0

[State 21550:           Turn]
type     = Turn
trigger1 = Parent,Facing != Facing

;-------[ Anim ]-------;

[State 21550:           Maya]
type        = Explod
trigger1    = !NumExplod(21550)
anim        = 21570
id          = 21550
postype     = p1
pos         = Floor(52 * const(size.xscale)), Floor(-209 * const(size.yscale))
scale       = const(size.xscale), const(size.yscale)
ownpal      = 1
bindtime    = -1
removetime = -1
sprpriority = -2

[State 21550:           Kaya]
type        = Explod
trigger1    = !NumExplod(21650)
anim        = 21670
id          = 21650
postype     = p1
pos         = Floor(-72 * const(size.xscale)), Floor(-206 * const(size.yscale))
scale       = const(size.xscale), const(size.yscale)
ownpal      = 1
bindtime    = -1
removetime = -1
sprpriority = -2

;------------------------------------------------------------------------------;
; マーヤ & カーヤ 消滅
;------------------------------------------------------------------------------;
[Statedef 21590]
type     = A
movetype = I
physics  = N
anim     = 9999
ctrl     = 0

;-------[ Effects ]-------;

[State 21500:           Effect, 1]
type        = Helper
trigger1    = Time = 0
helpertype  = Normal
name        = "Maya Light"
stateno     = 7560
id          = 7560
postype     = p1
pos         = Floor(52 * const(size.xscale)), Floor(-209 * const(size.yscale))
ownpal      = 1
size.xscale = const(size.xscale)
size.yscale = const(size.yscale)
persistent  = 0

[State 21500:           Effect, 2]
type        = Helper
trigger1    = Time = 0
helpertype  = Normal
name        = "Kaya Light"
stateno     = 7560
id          = 7561
postype     = p1
pos         = Floor(-72 * const(size.xscale)), Floor(-206 * const(size.yscale))
ownpal      = 1
size.xscale = const(size.xscale)
size.yscale = const(size.yscale)
persistent  = 0

;-------[ Remove Kaya & Maya ]-------;

[State 21500:           Remove Maya]
type     = RemoveExplod
trigger1 = Time = 0
id       = 21550

[State 21500:           Remove Kaya]
type     = RemoveExplod
trigger1 = Time = 0
id       = 21650

;-------[ Destroy ]-------;

[State 21500:           Destroy]
type     = DestroySelf
trigger1 = !NumHelper(7560)
trigger1 = !NumHelper(7561)


;==============================================================================;
; Last Revision : $Rev: 1298 $
; Last Modified : $Date: 2011-03-08 23:09:42 +0900 (火, 08 3 2011) $
;==============================================================================;
